<?php
/**
 * PublicImportResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Imports
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Imports
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Imports\Model;

use \ArrayAccess;
use \HubSpot\Client\Crm\Imports\ObjectSerializer;

/**
 * PublicImportResponse Class Doc Comment
 *
 * @category Class
 * @description A current summary of the import, whether complete or not.
 * @package  HubSpot\Client\Crm\Imports
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PublicImportResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PublicImportResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'import_template' => '\HubSpot\Client\Crm\Imports\Model\ImportTemplate',
        'created_at' => '\DateTime',
        'metadata' => '\HubSpot\Client\Crm\Imports\Model\PublicImportMetadata',
        'import_request_json' => 'object',
        'import_source' => 'string',
        'import_name' => 'string',
        'state' => 'string',
        'id' => 'string',
        'opt_out_import' => 'bool',
        'updated_at' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'import_template' => null,
        'created_at' => 'date-time',
        'metadata' => null,
        'import_request_json' => null,
        'import_source' => null,
        'import_name' => null,
        'state' => null,
        'id' => null,
        'opt_out_import' => null,
        'updated_at' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'import_template' => false,
        'created_at' => false,
        'metadata' => false,
        'import_request_json' => false,
        'import_source' => false,
        'import_name' => false,
        'state' => false,
        'id' => false,
        'opt_out_import' => false,
        'updated_at' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'import_template' => 'importTemplate',
        'created_at' => 'createdAt',
        'metadata' => 'metadata',
        'import_request_json' => 'importRequestJson',
        'import_source' => 'importSource',
        'import_name' => 'importName',
        'state' => 'state',
        'id' => 'id',
        'opt_out_import' => 'optOutImport',
        'updated_at' => 'updatedAt'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'import_template' => 'setImportTemplate',
        'created_at' => 'setCreatedAt',
        'metadata' => 'setMetadata',
        'import_request_json' => 'setImportRequestJson',
        'import_source' => 'setImportSource',
        'import_name' => 'setImportName',
        'state' => 'setState',
        'id' => 'setId',
        'opt_out_import' => 'setOptOutImport',
        'updated_at' => 'setUpdatedAt'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'import_template' => 'getImportTemplate',
        'created_at' => 'getCreatedAt',
        'metadata' => 'getMetadata',
        'import_request_json' => 'getImportRequestJson',
        'import_source' => 'getImportSource',
        'import_name' => 'getImportName',
        'state' => 'getState',
        'id' => 'getId',
        'opt_out_import' => 'getOptOutImport',
        'updated_at' => 'getUpdatedAt'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const IMPORT_SOURCE_API = 'API';
    public const IMPORT_SOURCE_CRM_UI = 'CRM_UI';
    public const IMPORT_SOURCE_IMPORT = 'IMPORT';
    public const IMPORT_SOURCE_MOBILE_ANDROID = 'MOBILE_ANDROID';
    public const IMPORT_SOURCE_MOBILE_IOS = 'MOBILE_IOS';
    public const IMPORT_SOURCE_SALESFORCE = 'SALESFORCE';
    public const STATE_STARTED = 'STARTED';
    public const STATE_PROCESSING = 'PROCESSING';
    public const STATE_DONE = 'DONE';
    public const STATE_FAILED = 'FAILED';
    public const STATE_CANCELED = 'CANCELED';
    public const STATE_DEFERRED = 'DEFERRED';
    public const STATE_REVERTED = 'REVERTED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getImportSourceAllowableValues()
    {
        return [
            self::IMPORT_SOURCE_API,
            self::IMPORT_SOURCE_CRM_UI,
            self::IMPORT_SOURCE_IMPORT,
            self::IMPORT_SOURCE_MOBILE_ANDROID,
            self::IMPORT_SOURCE_MOBILE_IOS,
            self::IMPORT_SOURCE_SALESFORCE,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_STARTED,
            self::STATE_PROCESSING,
            self::STATE_DONE,
            self::STATE_FAILED,
            self::STATE_CANCELED,
            self::STATE_DEFERRED,
            self::STATE_REVERTED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('import_template', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('metadata', $data ?? [], null);
        $this->setIfExists('import_request_json', $data ?? [], null);
        $this->setIfExists('import_source', $data ?? [], null);
        $this->setIfExists('import_name', $data ?? [], null);
        $this->setIfExists('state', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('opt_out_import', $data ?? [], null);
        $this->setIfExists('updated_at', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['created_at'] === null) {
            $invalidProperties[] = "'created_at' can't be null";
        }
        if ($this->container['metadata'] === null) {
            $invalidProperties[] = "'metadata' can't be null";
        }
        $allowedValues = $this->getImportSourceAllowableValues();
        if (!is_null($this->container['import_source']) && !in_array($this->container['import_source'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'import_source', must be one of '%s'",
                $this->container['import_source'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['state'] === null) {
            $invalidProperties[] = "'state' can't be null";
        }
        $allowedValues = $this->getStateAllowableValues();
        if (!is_null($this->container['state']) && !in_array($this->container['state'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'state', must be one of '%s'",
                $this->container['state'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['opt_out_import'] === null) {
            $invalidProperties[] = "'opt_out_import' can't be null";
        }
        if ($this->container['updated_at'] === null) {
            $invalidProperties[] = "'updated_at' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets import_template
     *
     * @return \HubSpot\Client\Crm\Imports\Model\ImportTemplate|null
     */
    public function getImportTemplate()
    {
        return $this->container['import_template'];
    }

    /**
     * Sets import_template
     *
     * @param \HubSpot\Client\Crm\Imports\Model\ImportTemplate|null $import_template import_template
     *
     * @return self
     */
    public function setImportTemplate($import_template)
    {
        if (is_null($import_template)) {
            throw new \InvalidArgumentException('non-nullable import_template cannot be null');
        }
        $this->container['import_template'] = $import_template;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime $created_at created_at
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets metadata
     *
     * @return \HubSpot\Client\Crm\Imports\Model\PublicImportMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     *
     * @param \HubSpot\Client\Crm\Imports\Model\PublicImportMetadata $metadata metadata
     *
     * @return self
     */
    public function setMetadata($metadata)
    {
        if (is_null($metadata)) {
            throw new \InvalidArgumentException('non-nullable metadata cannot be null');
        }
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets import_request_json
     *
     * @return object|null
     */
    public function getImportRequestJson()
    {
        return $this->container['import_request_json'];
    }

    /**
     * Sets import_request_json
     *
     * @param object|null $import_request_json import_request_json
     *
     * @return self
     */
    public function setImportRequestJson($import_request_json)
    {
        if (is_null($import_request_json)) {
            throw new \InvalidArgumentException('non-nullable import_request_json cannot be null');
        }
        $this->container['import_request_json'] = $import_request_json;

        return $this;
    }

    /**
     * Gets import_source
     *
     * @return string|null
     */
    public function getImportSource()
    {
        return $this->container['import_source'];
    }

    /**
     * Sets import_source
     *
     * @param string|null $import_source import_source
     *
     * @return self
     */
    public function setImportSource($import_source)
    {
        if (is_null($import_source)) {
            throw new \InvalidArgumentException('non-nullable import_source cannot be null');
        }
        $allowedValues = $this->getImportSourceAllowableValues();
        if (!in_array($import_source, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'import_source', must be one of '%s'",
                    $import_source,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['import_source'] = $import_source;

        return $this;
    }

    /**
     * Gets import_name
     *
     * @return string|null
     */
    public function getImportName()
    {
        return $this->container['import_name'];
    }

    /**
     * Sets import_name
     *
     * @param string|null $import_name import_name
     *
     * @return self
     */
    public function setImportName($import_name)
    {
        if (is_null($import_name)) {
            throw new \InvalidArgumentException('non-nullable import_name cannot be null');
        }
        $this->container['import_name'] = $import_name;

        return $this;
    }

    /**
     * Gets state
     *
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     *
     * @param string $state The status of the import.
     *
     * @return self
     */
    public function setState($state)
    {
        if (is_null($state)) {
            throw new \InvalidArgumentException('non-nullable state cannot be null');
        }
        $allowedValues = $this->getStateAllowableValues();
        if (!in_array($state, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'state', must be one of '%s'",
                    $state,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets opt_out_import
     *
     * @return bool
     */
    public function getOptOutImport()
    {
        return $this->container['opt_out_import'];
    }

    /**
     * Sets opt_out_import
     *
     * @param bool $opt_out_import Whether or not the import is a list of people disqualified from receiving emails.
     *
     * @return self
     */
    public function setOptOutImport($opt_out_import)
    {
        if (is_null($opt_out_import)) {
            throw new \InvalidArgumentException('non-nullable opt_out_import cannot be null');
        }
        $this->container['opt_out_import'] = $opt_out_import;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param \DateTime $updated_at updated_at
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        if (is_null($updated_at)) {
            throw new \InvalidArgumentException('non-nullable updated_at cannot be null');
        }
        $this->container['updated_at'] = $updated_at;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


