<?php
/**
 * ParticipantStateApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Marketing Events
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Events\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Marketing\Events\ApiException;
use HubSpot\Client\Marketing\Events\Configuration;
use HubSpot\Client\Marketing\Events\HeaderSelector;
use HubSpot\Client\Marketing\Events\ObjectSerializer;

/**
 * ParticipantStateApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ParticipantStateApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getParticipationsBreakdownByContactId' => [
            'application/json',
        ],
        'getParticipationsBreakdownByExternalEventId' => [
            'application/json',
        ],
        'getParticipationsBreakdownByMarketingEventId' => [
            'application/json',
        ],
        'getParticipationsCountersByEventExternalId' => [
            'application/json',
        ],
        'getParticipationsCountersByMarketingEventId' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getParticipationsBreakdownByContactId
     *
     * Read participations breakdown by Contact identifier
     *
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (required)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByContactId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function getParticipationsBreakdownByContactId($contact_identifier, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByContactId'][0])
    {
        list($response) = $this->getParticipationsBreakdownByContactIdWithHttpInfo($contact_identifier, $state, $limit, $after, $contentType);
        return $response;
    }

    /**
     * Operation getParticipationsBreakdownByContactIdWithHttpInfo
     *
     * Read participations breakdown by Contact identifier
     *
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (required)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByContactId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getParticipationsBreakdownByContactIdWithHttpInfo($contact_identifier, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByContactId'][0])
    {
        $request = $this->getParticipationsBreakdownByContactIdRequest($contact_identifier, $state, $limit, $after, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getParticipationsBreakdownByContactIdAsync
     *
     * Read participations breakdown by Contact identifier
     *
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (required)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByContactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getParticipationsBreakdownByContactIdAsync($contact_identifier, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByContactId'][0])
    {
        return $this->getParticipationsBreakdownByContactIdAsyncWithHttpInfo($contact_identifier, $state, $limit, $after, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getParticipationsBreakdownByContactIdAsyncWithHttpInfo
     *
     * Read participations breakdown by Contact identifier
     *
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (required)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByContactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getParticipationsBreakdownByContactIdAsyncWithHttpInfo($contact_identifier, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByContactId'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging';
        $request = $this->getParticipationsBreakdownByContactIdRequest($contact_identifier, $state, $limit, $after, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getParticipationsBreakdownByContactId'
     *
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (required)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByContactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getParticipationsBreakdownByContactIdRequest($contact_identifier, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByContactId'][0])
    {

        // verify the required parameter 'contact_identifier' is set
        if ($contact_identifier === null || (is_array($contact_identifier) && count($contact_identifier) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $contact_identifier when calling getParticipationsBreakdownByContactId'
            );
        }





        $resourcePath = '/marketing/v3/marketing-events/participations/contacts/{contactIdentifier}/breakdown';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $state,
            'state', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($contact_identifier !== null) {
            $resourcePath = str_replace(
                '{' . 'contactIdentifier' . '}',
                ObjectSerializer::toPathValue($contact_identifier),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getParticipationsBreakdownByExternalEventId
     *
     * Read participations breakdown by Marketing Event external identifier
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (optional)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByExternalEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function getParticipationsBreakdownByExternalEventId($external_account_id, $external_event_id, $contact_identifier = null, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByExternalEventId'][0])
    {
        list($response) = $this->getParticipationsBreakdownByExternalEventIdWithHttpInfo($external_account_id, $external_event_id, $contact_identifier, $state, $limit, $after, $contentType);
        return $response;
    }

    /**
     * Operation getParticipationsBreakdownByExternalEventIdWithHttpInfo
     *
     * Read participations breakdown by Marketing Event external identifier
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (optional)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByExternalEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getParticipationsBreakdownByExternalEventIdWithHttpInfo($external_account_id, $external_event_id, $contact_identifier = null, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByExternalEventId'][0])
    {
        $request = $this->getParticipationsBreakdownByExternalEventIdRequest($external_account_id, $external_event_id, $contact_identifier, $state, $limit, $after, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getParticipationsBreakdownByExternalEventIdAsync
     *
     * Read participations breakdown by Marketing Event external identifier
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (optional)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByExternalEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getParticipationsBreakdownByExternalEventIdAsync($external_account_id, $external_event_id, $contact_identifier = null, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByExternalEventId'][0])
    {
        return $this->getParticipationsBreakdownByExternalEventIdAsyncWithHttpInfo($external_account_id, $external_event_id, $contact_identifier, $state, $limit, $after, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getParticipationsBreakdownByExternalEventIdAsyncWithHttpInfo
     *
     * Read participations breakdown by Marketing Event external identifier
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (optional)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByExternalEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getParticipationsBreakdownByExternalEventIdAsyncWithHttpInfo($external_account_id, $external_event_id, $contact_identifier = null, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByExternalEventId'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging';
        $request = $this->getParticipationsBreakdownByExternalEventIdRequest($external_account_id, $external_event_id, $contact_identifier, $state, $limit, $after, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getParticipationsBreakdownByExternalEventId'
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (optional)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByExternalEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getParticipationsBreakdownByExternalEventIdRequest($external_account_id, $external_event_id, $contact_identifier = null, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByExternalEventId'][0])
    {

        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling getParticipationsBreakdownByExternalEventId'
            );
        }

        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling getParticipationsBreakdownByExternalEventId'
            );
        }






        $resourcePath = '/marketing/v3/marketing-events/participations/{externalAccountId}/{externalEventId}/breakdown';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $contact_identifier,
            'contactIdentifier', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $state,
            'state', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($external_account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalAccountId' . '}',
                ObjectSerializer::toPathValue($external_account_id),
                $resourcePath
            );
        }
        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getParticipationsBreakdownByMarketingEventId
     *
     * Read participations breakdown by Marketing Event internal identifier
     *
     * @param  int $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (optional)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function getParticipationsBreakdownByMarketingEventId($marketing_event_id, $contact_identifier = null, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByMarketingEventId'][0])
    {
        list($response) = $this->getParticipationsBreakdownByMarketingEventIdWithHttpInfo($marketing_event_id, $contact_identifier, $state, $limit, $after, $contentType);
        return $response;
    }

    /**
     * Operation getParticipationsBreakdownByMarketingEventIdWithHttpInfo
     *
     * Read participations breakdown by Marketing Event internal identifier
     *
     * @param  int $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (optional)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getParticipationsBreakdownByMarketingEventIdWithHttpInfo($marketing_event_id, $contact_identifier = null, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByMarketingEventId'][0])
    {
        $request = $this->getParticipationsBreakdownByMarketingEventIdRequest($marketing_event_id, $contact_identifier, $state, $limit, $after, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getParticipationsBreakdownByMarketingEventIdAsync
     *
     * Read participations breakdown by Marketing Event internal identifier
     *
     * @param  int $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (optional)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getParticipationsBreakdownByMarketingEventIdAsync($marketing_event_id, $contact_identifier = null, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByMarketingEventId'][0])
    {
        return $this->getParticipationsBreakdownByMarketingEventIdAsyncWithHttpInfo($marketing_event_id, $contact_identifier, $state, $limit, $after, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getParticipationsBreakdownByMarketingEventIdAsyncWithHttpInfo
     *
     * Read participations breakdown by Marketing Event internal identifier
     *
     * @param  int $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (optional)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getParticipationsBreakdownByMarketingEventIdAsyncWithHttpInfo($marketing_event_id, $contact_identifier = null, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByMarketingEventId'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalParticipationBreakdownForwardPaging';
        $request = $this->getParticipationsBreakdownByMarketingEventIdRequest($marketing_event_id, $contact_identifier, $state, $limit, $after, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getParticipationsBreakdownByMarketingEventId'
     *
     * @param  int $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contact_identifier The identifier of the Contact. It may be email or internal id. (optional)
     * @param  string $state The participation state value. It may be REGISTERED, CANCELLED, ATTENDED, NO_SHOW (optional)
     * @param  int $limit The limit for response size. The default value is 10, the max number is 100 (optional, default to 10)
     * @param  string $after The cursor indicating the position of the last retrieved item. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsBreakdownByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getParticipationsBreakdownByMarketingEventIdRequest($marketing_event_id, $contact_identifier = null, $state = null, $limit = 10, $after = null, string $contentType = self::contentTypes['getParticipationsBreakdownByMarketingEventId'][0])
    {

        // verify the required parameter 'marketing_event_id' is set
        if ($marketing_event_id === null || (is_array($marketing_event_id) && count($marketing_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketing_event_id when calling getParticipationsBreakdownByMarketingEventId'
            );
        }






        $resourcePath = '/marketing/v3/marketing-events/participations/{marketingEventId}/breakdown';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $contact_identifier,
            'contactIdentifier', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $state,
            'state', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $after,
            'after', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($marketing_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'marketingEventId' . '}',
                ObjectSerializer::toPathValue($marketing_event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getParticipationsCountersByEventExternalId
     *
     * Read participations counters by Marketing Event external identifier
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsCountersByEventExternalId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\AttendanceCounters|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function getParticipationsCountersByEventExternalId($external_account_id, $external_event_id, string $contentType = self::contentTypes['getParticipationsCountersByEventExternalId'][0])
    {
        list($response) = $this->getParticipationsCountersByEventExternalIdWithHttpInfo($external_account_id, $external_event_id, $contentType);
        return $response;
    }

    /**
     * Operation getParticipationsCountersByEventExternalIdWithHttpInfo
     *
     * Read participations counters by Marketing Event external identifier
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsCountersByEventExternalId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\AttendanceCounters|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getParticipationsCountersByEventExternalIdWithHttpInfo($external_account_id, $external_event_id, string $contentType = self::contentTypes['getParticipationsCountersByEventExternalId'][0])
    {
        $request = $this->getParticipationsCountersByEventExternalIdRequest($external_account_id, $external_event_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\AttendanceCounters' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\AttendanceCounters' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\AttendanceCounters', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\AttendanceCounters';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\AttendanceCounters',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getParticipationsCountersByEventExternalIdAsync
     *
     * Read participations counters by Marketing Event external identifier
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsCountersByEventExternalId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getParticipationsCountersByEventExternalIdAsync($external_account_id, $external_event_id, string $contentType = self::contentTypes['getParticipationsCountersByEventExternalId'][0])
    {
        return $this->getParticipationsCountersByEventExternalIdAsyncWithHttpInfo($external_account_id, $external_event_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getParticipationsCountersByEventExternalIdAsyncWithHttpInfo
     *
     * Read participations counters by Marketing Event external identifier
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsCountersByEventExternalId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getParticipationsCountersByEventExternalIdAsyncWithHttpInfo($external_account_id, $external_event_id, string $contentType = self::contentTypes['getParticipationsCountersByEventExternalId'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\AttendanceCounters';
        $request = $this->getParticipationsCountersByEventExternalIdRequest($external_account_id, $external_event_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getParticipationsCountersByEventExternalId'
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsCountersByEventExternalId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getParticipationsCountersByEventExternalIdRequest($external_account_id, $external_event_id, string $contentType = self::contentTypes['getParticipationsCountersByEventExternalId'][0])
    {

        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling getParticipationsCountersByEventExternalId'
            );
        }

        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling getParticipationsCountersByEventExternalId'
            );
        }


        $resourcePath = '/marketing/v3/marketing-events/participations/{externalAccountId}/{externalEventId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalAccountId' . '}',
                ObjectSerializer::toPathValue($external_account_id),
                $resourcePath
            );
        }
        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getParticipationsCountersByMarketingEventId
     *
     * Read participations counters by Marketing Event internal identifier
     *
     * @param  int $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsCountersByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\AttendanceCounters|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function getParticipationsCountersByMarketingEventId($marketing_event_id, string $contentType = self::contentTypes['getParticipationsCountersByMarketingEventId'][0])
    {
        list($response) = $this->getParticipationsCountersByMarketingEventIdWithHttpInfo($marketing_event_id, $contentType);
        return $response;
    }

    /**
     * Operation getParticipationsCountersByMarketingEventIdWithHttpInfo
     *
     * Read participations counters by Marketing Event internal identifier
     *
     * @param  int $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsCountersByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\AttendanceCounters|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getParticipationsCountersByMarketingEventIdWithHttpInfo($marketing_event_id, string $contentType = self::contentTypes['getParticipationsCountersByMarketingEventId'][0])
    {
        $request = $this->getParticipationsCountersByMarketingEventIdRequest($marketing_event_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\AttendanceCounters' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\AttendanceCounters' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\AttendanceCounters', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\AttendanceCounters';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\AttendanceCounters',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getParticipationsCountersByMarketingEventIdAsync
     *
     * Read participations counters by Marketing Event internal identifier
     *
     * @param  int $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsCountersByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getParticipationsCountersByMarketingEventIdAsync($marketing_event_id, string $contentType = self::contentTypes['getParticipationsCountersByMarketingEventId'][0])
    {
        return $this->getParticipationsCountersByMarketingEventIdAsyncWithHttpInfo($marketing_event_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getParticipationsCountersByMarketingEventIdAsyncWithHttpInfo
     *
     * Read participations counters by Marketing Event internal identifier
     *
     * @param  int $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsCountersByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getParticipationsCountersByMarketingEventIdAsyncWithHttpInfo($marketing_event_id, string $contentType = self::contentTypes['getParticipationsCountersByMarketingEventId'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\AttendanceCounters';
        $request = $this->getParticipationsCountersByMarketingEventIdRequest($marketing_event_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getParticipationsCountersByMarketingEventId'
     *
     * @param  int $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getParticipationsCountersByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getParticipationsCountersByMarketingEventIdRequest($marketing_event_id, string $contentType = self::contentTypes['getParticipationsCountersByMarketingEventId'][0])
    {

        // verify the required parameter 'marketing_event_id' is set
        if ($marketing_event_id === null || (is_array($marketing_event_id) && count($marketing_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketing_event_id when calling getParticipationsCountersByMarketingEventId'
            );
        }


        $resourcePath = '/marketing/v3/marketing-events/participations/{marketingEventId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($marketing_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'marketingEventId' . '}',
                ObjectSerializer::toPathValue($marketing_event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
